% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matW.R
\name{matW}
\alias{matW}
\title{Calculate matrix W}
\usage{
matW(E, G)
}
\arguments{
\item{E}{Observed matrix of E variables, of dimension n x q.}

\item{G}{Observed matrix of G variables, of dimensions n x p.}
}
\value{
A matrix of dimension n x [p(q+1)].
}
\description{
Calculate observed matrix W for all G variables and G-E interactions. Denote Wj as the n x (q+1) sub-matrix of W corresponding the jth G variable.
 The first column of Wj is the observation vector of the jth G variable, and the rest q columns of Wj are observations of G-E interactions.
}
\examples{
n <- 30; q <- 3; p <- 5;
E <- MASS::mvrnorm (n, rep (0, q), diag (q))
G <- MASS::mvrnorm (n, rep (0, p), diag (p))
W <- matW (E, G)
}
