% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_audit_color.R
\name{gg_audit_color}
\alias{gg_audit_color}
\title{Audit Color Palette for Accessibility Issues}
\usage{
gg_audit_color(plot)
}
\arguments{
\item{plot}{A ggplot2 object}
}
\value{
A list of issues, warnings, and suggestions
}
\description{
Checks if a ggplot2 object uses colors that may be problematic
for colorblind users and provides detailed analysis.
}
\examples{
library(ggplot2)
p <- ggplot(mtcars, aes(wt, mpg, color = factor(cyl))) +
  geom_point() +
  scale_color_manual(values = c("red", "green", "blue"))
gg_audit_color(p)
}
