% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_covariates.R
\name{cov_uni}
\alias{cov_uni}
\title{Build Univariable Covariate Sets}
\usage{
cov_uni(covariates = NULL, pattern = NULL, name = NULL)
}
\arguments{
\item{covariates}{A character vector of covariate names. Typically the output from \code{\link{extract_names}}.}

\item{pattern}{A character vector specifying the prefix pattern(s) to match (e.g., "tmin" matches "tmin", "tmin.l1", etc.).}

\item{name}{A character vector specifying exact variable name(s) to extract.}
}
\value{
A list of character vectors, each of length 1, containing the matched covariate name.
The resulting list is suitable for use as the \code{covariates} argument in \code{\link{write_inla_formulas}}.
}
\description{
This function returns a list where each element contains a single covariate, based on
covariates specified in the \code{pattern} or \code{name} arguments. This structure is
suitable for generating separate univariable model formulas using \code{\link{write_inla_formulas}}.
}
\examples{
data <- data.frame(tmin = rnorm(10), tmin.l1 = rnorm(10), urban = rnorm(10))
covs <- extract_names(data, pattern = "tmin", name = "urban")
cov_uni(covs, pattern = "tmin")
cov_uni(covs, name = "urban")
}
