% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GIFT_checklists.R
\name{GIFT_checklists}
\alias{GIFT_checklists}
\title{GIFT checklists}
\usage{
GIFT_checklists(
  taxon_name = "Tracheophyta",
  complete_taxon = TRUE,
  floristic_group = c("all", "native", "endemic", "naturalized")[2],
  complete_floristic = TRUE,
  geo_type = c("All", "Mainland", "Island")[1],
  ref_excluded = NULL,
  suit_geo = FALSE,
  shp = NULL,
  coordinates = NULL,
  overlap = "centroid_inside",
  remove_overlap = FALSE,
  area_threshold_island = 0,
  area_threshold_mainland = 100,
  overlap_threshold = 0.1,
  by_ref_ID = FALSE,
  taxonomic_group = TRUE,
  namesmatched = FALSE,
  list_set_only = FALSE,
  GIFT_version = "latest",
  api = "https://gift.uni-goettingen.de/api/extended/"
)
}
\arguments{
\item{taxon_name}{Character string corresponding to the taxonomic group
of interest.}

\item{complete_taxon}{logical stating you want to retrieve checklists that
only contain the exhaustive list of the \code{taxon_name} argument or as well
incomplete lists.}

\item{floristic_group}{Character among the following options: \code{all},
\code{native}, \code{endemic}, \code{naturalized}.}

\item{complete_floristic}{logical stating you want to retrieve checklists
that only contain the exhaustive list of the \code{floristic_group} argument or
as well incomplete lists.}

\item{geo_type}{Character string, either \code{Mainland}, \code{Island} or
\code{All}. \code{Island} gets you to Island, Island Group &
Island Part. \code{Mainland} gets you to Mainland & Island/Mainland. \code{All} gets
you all types.}

\item{ref_excluded}{A vector listing potential ref_IDs that shall be ignored
when assembling the set of regions and checklists fulfilling the given
criteria. Checklists from these references will not be returned. NULL by
default.}

\item{suit_geo}{logical indicating whether only regions classified as
suit_geo should be considered (see details).}

\item{shp}{Shapefile provided by the user.}

\item{coordinates}{Custom set of coordinates. The format is a two columns
data.frame, the first one being longitudes and the second being latitudes
of the vertices of a polygon. If the data.frame only includes two rows,
the function assumes that the values are the four limits (min and max.
longitude and latitude) of a bounding box.}

\item{overlap}{A character string defining the criteria to use in order to
retrieve checklists. Available options are \code{centroid_inside},
\code{extent_intersect}, \code{shape_intersect} and \code{shape_inside}. For example,
\code{extent_intersect} means that every polygon from GIFT for which the extent
intersects the provided shape/coordinates will be retrieved.}

\item{remove_overlap}{a logical stating whether you want to
retrieve checklists that overlap or not.}

\item{area_threshold_island}{A number stating from which surface the
smallest overlapping polygon is kept. By default set to 0 square kilometer
(meaning that by default the smallest islands will be conserved).}

\item{area_threshold_mainland}{When two polygons overlap, the smallest or
the biggest one can be kept. When the surface of the smallest polygon
exceeds this number, the smallest polygon is kept. Otherwise, we keep the
bigger one. Set by default 100 square-kilometers.}

\item{overlap_threshold}{A number ranging from 0 to 1, indicating at what
percentage of overlap, partially overlapping polygons should be kept.}

\item{by_ref_ID}{logical indicating whether the removal of overlapping
regions shall be applied by \emph{ref_ID} only. Note that regions
overlapping with other regions from the same resource will be removed even
if there are other references available for those regions.}

\item{taxonomic_group}{logical. When set to \code{TRUE}, two additional columns
(\emph{family} and \emph{tax_group}) are available in the checklists.}

\item{namesmatched}{logical. \code{FALSE} by default, set to \code{TRUE} if you want
the original species name as they came in the references as well as details
on the taxonomic harmonization.}

\item{list_set_only}{logical stating whether you only want the metadata or
if you also want to retrieve the species lists.}

\item{GIFT_version}{character string defining the version of the GIFT
database to use. The function retrieves by default the \code{latest} stable
version. If set to \code{beta}, the most up-to-date version which is still
subject to changes and edits is used.}

\item{api}{character string defining from which API the data will be
retrieved.}
}
\value{
List with two data frames: the checklist with species and the list of ID.
}
\description{
Retrieve GIFT checklists that fulfill specific criteria.
}
\details{
Here is the detail of each data.frame and their columns:

\emph{ref_ID} - Identification number of each reference.\cr
\emph{type}- What type the source is.\cr
\emph{subset}- What information regarding the status of species is
available.\cr
\emph{native_indicated}- Whether native status of species is available in
the source.\cr
\emph{natural_indicated} - Whether naturalized status of species is
available in the source.\cr
\emph{end_ref} - Whether endemism information is available in the
source.\cr
\emph{restricted} - Whether the access to this reference is
restricted.\cr
\emph{taxon_ID}- Identification number of species.\cr
\emph{list_ID} - Identification number of each list.\cr
\emph{end_list} - Whether endemism information is available in the list.\cr
\emph{entity_ID}- Identification number of the polygon of the list.\cr
\emph{geo_entity} - Name of the location.\cr
\emph{suit_geo} - Is the polygon suitable.\cr
\emph{entity_class} - Type of polygon.\cr
\emph{entity_type} - Name of the location.\cr
\emph{taxon_name} - Name of the group of taxa available.

For the second data frame with the species, each column refers to:

\emph{ref_ID} - Identification number of each reference.\cr
\emph{list_ID} - Identification number of each list\cr
\emph{work_ID} - Identification number of each species name, after taxonomic
harmonization.\cr
\emph{genus_ID} - Identification number of each genus, after taxonomic
harmonization.\cr
\emph{species} - Species name, after taxonomic harmonization.\cr
\emph{questionable} - Whether the species occurrence is questionable.\cr
\emph{native} - Whether the species is native.\cr
\emph{quest_native} - Whether the native information is questionable.\cr
\emph{naturalized} - Whether the species is naturalized.\cr
\emph{endemic_ref} - Whether the species is endemic within the reference.\cr
\emph{quest_end_ref} - Whether the endemic_ref information is
questionable.\cr
\emph{endemic_list} - Whether the species is endemic within the list.\cr
\emph{quest_end_list} - Whether the endemic_list information is
questionable.\cr
\emph{cons_status} - Conservation status of the species.\cr
\emph{family} - Family of the species.\cr
\emph{tax_group} - Taxonomic group of the species.

While the arguments \code{taxon_name} in combination with \code{complete_taxon = TRUE}
and \code{floristic_group} in combination with \code{complete_floristic = TRUE} make
sure to only get back checklists for regions for which GIFT has lists
aiming at covering both the entire taxonomic group and floristic subset (for
example native vascular plants), it does not mean that the checklists are
complete (include all species). We therefore flagged regions in GIFT for
which the combination of all checklists is obviously incomplete as
\code{suit_geo = 0}. This has however only been done only for native angiosperms
and the assessment has been subjective. Set \code{suit_geo = TRUE} if you only
want to consider regions classified as \code{suit_geo}.
}
\examples{
\donttest{
data("western_mediterranean")
ex <- GIFT_checklists(shp = western_mediterranean,
overlap = "centroid_inside", taxon_name = "Angiospermae",
list_set_only = TRUE) # set to FALSE to get species composition
}

}
\references{
\if{html}{\out{<div class="sourceCode">}}\preformatted{ Denelle, P., Weigelt, P., & Kreft, H. (2023). GIFT—An R package to
 access the Global Inventory of Floras and Traits. Methods in Ecology
 and Evolution, 14, 2738-2748.
 https://doi.org/10.1111/2041-210X.14213

 Weigelt, P, König, C, Kreft, H. GIFT – A Global Inventory of Floras and
 Traits for macroecology and biogeography. J Biogeogr. 2020; 47: 16– 43.
 https://doi.org/10.1111/jbi.13623
}\if{html}{\out{</div>}}
}
\seealso{
\code{\link[=GIFT_checklists_raw]{GIFT_checklists_raw()}}
}
