% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GIFT_lists.R
\name{GIFT_lists}
\alias{GIFT_lists}
\title{Metadata for checklists available in GIFT}
\usage{
GIFT_lists(
  api = "https://gift.uni-goettingen.de/api/extended/",
  GIFT_version = "latest"
)
}
\arguments{
\item{api}{character string defining from which API the data will be
retrieved.}

\item{GIFT_version}{character string defining the version of the GIFT
database to use. The function retrieves by default the \code{latest} stable
version. If set to \code{beta}, the most up-to-date version which is still
subject to changes and edits is used.}
}
\value{
A data frame with 15 columns.
}
\description{
Retrieves the metadata of each checklist within GIFT.
}
\details{
Here is what each column refers to:

\emph{ref_ID} - Identification number of each reference.\cr
Columns \emph{type} and \emph{subset} indicate what information can be
found in each reference. Similarly, \emph{native_indicated},
\emph{natural_indicated} and \emph{end_ref} indicate respectively
whether native, naturalized and endemic species were stated in the
reference. \emph{restricted} refers to the availability of the reference,
\emph{taxon_ID} to the taxonomic group available in a reference.
\emph{list_ID} is the identification number of a checklist within a
reference, \emph{entity_ID} of the associated polygon. \emph{geo_entity}
associates a name to this identification number. \emph{suit_geo} indicates
whether the checklist is suitable for use, \emph{entity_class} and
\emph{entity_unit} give additional details about the polygon.
}
\examples{
\donttest{
ex <- GIFT_lists()
}

}
\references{
\if{html}{\out{<div class="sourceCode">}}\preformatted{ Denelle, P., Weigelt, P., & Kreft, H. (2023). GIFT—An R package to
 access the Global Inventory of Floras and Traits. Methods in Ecology
 and Evolution, 14, 2738-2748.
 https://doi.org/10.1111/2041-210X.14213

 Weigelt, P, König, C, Kreft, H. GIFT – A Global Inventory of Floras and
 Traits for macroecology and biogeography. J Biogeogr. 2020; 47: 16– 43.
 https://doi.org/10.1111/jbi.13623
}\if{html}{\out{</div>}}
}
\seealso{
\code{\link[=GIFT_checklists]{GIFT_checklists()}}
}
