% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.gia.R
\name{predict.gia}
\alias{predict.gia}
\title{Predict GMDH GIA object}
\usage{
\method{predict}{gia}(object, newdata, ...)
}
\arguments{
\item{object}{an object of class 'giatwice'}

\item{newdata}{matrix containing dependent variables in the model, wich the predictions are calculated.}

\item{...}{other undocumented arguments}
}
\value{
A matrix with predictions.
}
\description{
Calculates GMDH GIA Twice model predictions for new data.
}
\examples{

set.seed(123)
x <- matrix(data = c(rnorm(500)), ncol = 4, nrow = 125)
colnames(x) <- c("a", "b", "c", "d")
y <- matrix(data = c(10 + x[, "a"] + x[, "d"]^2), ncol = 1)
colnames(y) <- "y"
x.test <- x[1:5, ]
y.test <- y[1:5]
x <- x[-c(1:5), ]
y <- y[-c(1:5)]

mod <- gmdh.gia(X = x, y = y, criteria = "PRESS")
pred <- predict(mod, x.test)
summary(sqrt((pred - y.test)^2))

}
