% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GO4org.R
\name{GO4Organism}
\alias{GO4Organism}
\title{All gene association GO-terms for an organism}
\usage{
GO4Organism(organism, domain = "BP")
}
\arguments{
\item{organism}{The organism supported by the package. Both the scientific / common name of the organism can be use}

\item{domain}{The ontology of the GO-terms. The default is BP.}
}
\value{
A two-column matrix that contains the GO-terms and their GO-levels
}
\description{
The function contains all the GO-terms associated with the genes of an organism and their levels.
             If "BP", "MF" or "CC" the GO-terms from the whole ontology is return and their levels.
             The supported organisms are "Homo sapiens / Human", "Rattus norvegicus / Rat", "Mus musculus / Mouse",
             "Danio rerio / Zebrafish", "Caenorhabditis elegans / Worm" ,"Arabidopsis thaliana / Cress",
             "Saccharomyces cerevisiae / Yeast", "Schizosaccharomyces pombe / Fission yeast",
             "Drosophila melanogaster / Fruit fly", "Escherichia coli / E.coli".
}
\examples{
# Return all the BP GO-terms associated with organism Homo sapiens
GO4Organism(organism = "Homo sapiens")

# Return all the CC GO-terms associated with organism Rat
GO4Organism(organism = "Rat", domain = "CC")
}
