% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{comparison_plot}
\alias{comparison_plot}
\title{Comparison Plot for p-values Across Growth Models}
\usage{
comparison_plot(
  data_path,
  window_size = 3,
  parameter,
  p_val_method,
  repetition
)
}
\arguments{
\item{data_path}{A character string specifying the path to the data file. The file should contain the necessary data for p-value calculations.}

\item{window_size}{An integer specifying the size of the moving window for calculations. Default is 3.}

\item{parameter}{A list of parameters used in p-value calculation.}

\item{p_val_method}{A character string specifying the method for p-value calculation. The options are Parametric and Non - Parametric methods.}

\item{repetition}{An integer specifying the number of repetitions for calculations.}
}
\value{
A plot comparing p-values across the Logistic, Von-Bertalanffy, and Gompertz models over time points. The plot includes lines for each model's p-values, a legend, and a reference line of tolerance = 0.05.
}
\description{
This function generates a comparison plot of p-values obtained from different growth models (Logistic, Von-Bertalanffy, and Gompertz) using real data. It visualizes how p-values vary across time points for the specified models and provides a horizontal reference line for significance.
}
\examples{
\donttest{
data_path <- system.file("extdata", "sample_data.csv", package = "GPEMR")
params <- list(log_r = 0.7,von_r = 0.3,c=0.2,b=0.1)
comparison_plot(data_path = data_path, window_size = 5, parameter = params,
                p_val_method = "Parametric", repetition = 2)}

}
