% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cano2M.R
\name{cano2M}
\alias{cano2M}
\title{cano2M : Converts a model in canonical form into a matrix form}
\usage{
cano2M(nVar, dMax, poly, dMin = 0)
}
\arguments{
\item{nVar}{The number of variables}

\item{dMax}{The maximum degree allowed in the formulation}

\item{poly}{A vector of coefficients corresponding to the regressor
of the canonical function}

\item{dMin}{The minimum negative degree of the polynomial
formulation (0 by default).}
}
\value{
\code{Kmod} A matrix with nVar columns of the complete description of the equations.
The first columns relates to the canonical part dX1/dt = X2, dX2/dt = X3 etc. and
the column is the polynomial term itself
}
\description{
Converts the vectorial formulation of canonical models
into a matrix formulation (that is, including explicitely all the
equations). For both input, the list of terms follows the convention
defined by \code{poLabs}.
}
\examples{
# A vector of polynomial terms corresponding to a canonical form:
polyTerms <- c(0.2,0,-1,0.5,0,0,0,0,0,0)
# Convert this vector into a matrix formulation with all the equations: 
K <- cano2M(3,2,polyTerms)
# Visualize the equations:
visuEq(K,3,2)

}
\seealso{
\code{\link{drvSucc}}, \code{\link{gPoMo}}, \code{\link{poLabs}}
}
\author{
Sylvain Mangiarotti, Mireille Huc
}
