% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomewide.log10q.plot.R
\name{genomewide.log10q.plot}
\alias{genomewide.log10q.plot}
\title{Genome-wide -log10(q-value) Plot}
\usage{
genomewide.log10q.plot(
  grin.res,
  lsn.grps,
  lsn.colors = NULL,
  max.log10q = NULL
)
}
\arguments{
\item{grin.res}{GRIN results object (output from \code{grin.stats}) using either gene annotation or lesion boundaries as marker input.}

\item{lsn.grps}{A character vector specifying which lesion group(s) to include in the plot.}

\item{lsn.colors}{A named vector of colors corresponding to each lesion group. If \code{NULL}, default colors will be assigned using the \code{default.grin.colors()} function.}

\item{max.log10q}{Numeric; maximum value for -log10(q-value) displayed on the plot. Any value above this threshold will be capped at \code{max.log10q}.}
}
\value{
A genome-wide plot showing -log10(q-values) for genes or lesion boundaries associated with specific lesion types.
}
\description{
Generates a genome-wide plot of -log10(q-values) for each annotated gene or lesion boundary evaluated by GRIN. The plot is lesion-type specific (e.g., gain, loss, mutation).
}
\details{
This function visualizes the significance of lesions affecting genomic loci across chromosomes. It plots -log10(q-values) for either gene-based or lesion-boundary markers based on the GRIN analysis. The plot is faceted or colored by lesion group (e.g., gain, loss).
}
\examples{
data(lesion_data)
data(hg38_gene_annotation)
data(hg38_chrom_size)

# Example 1: Use lesion boundaries for gains
gain <- lesion_data[lesion_data$lsn.type == "gain", ]
lsn.bound.gain <- grin.lsn.boundaries(gain, hg38_chrom_size)
GRIN.results.gain.bound <- grin.stats(gain, lsn.bound.gain, hg38_chrom_size)

genomewide.log10q.plot(GRIN.results.gain.bound,
                       lsn.grps = c("gain"),
                       lsn.colors = c("gain" = "red"),
                       max.log10q = 10)

# hg38_gene_annotation can be used instead of the boundaries as the marker data.

# This function can be used similarly for other lesion types (e.g., loss, mutation).
}
\seealso{
\code{\link{grin.lsn.boundaries}}
}
\author{
Abdelrahman Elsayed \email{abdelrahman.elsayed@stjude.org} and Stanley Pounds \email{stanley.pounds@stjude.org}
}
