% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomewide.lsn.plot.R
\name{genomewide.lsn.plot}
\alias{genomewide.lsn.plot}
\title{Genome-wide Lesion Plot}
\usage{
genomewide.lsn.plot(
  grin.res,
  ordered = FALSE,
  pt.order = NULL,
  lsn.colors = NULL,
  max.log10q = NULL
)
}
\arguments{
\item{grin.res}{GRIN results (output from the \code{grin.stats} function).}

\item{ordered}{Logical; if \code{TRUE}, patient IDs will be reordered according to the \code{pt.order} data frame. If \code{FALSE} (default), patient IDs are ordered alphabetically.}

\item{pt.order}{A data frame with two columns: \code{"ID"} (patient identifiers matching those in the lesion data) and \code{"pts.order"} (numeric vector specifying the new patient order from 1 to n patients). Only required if \code{ordered = TRUE}.}

\item{lsn.colors}{A named vector of colors assigned to lesion types. If not provided, colors will be automatically assigned using the \code{default.grin.colors} function.}

\item{max.log10q}{Numeric; maximum value for -log10(q-value) used in the plot. Any value greater than \code{max.log10q} will be capped at this value in the left panel of the plot.}
}
\value{
A genome-wide lesion plot consisting of three aligned panels:
\itemize{
\item Middle panel: genome-wide lesion map across all chromosomes and patients.
\item Left panel: -log10(q-values) of each locus from GRIN results showing Statistical Significance of Lesion Frequencies.
\item Right panel: number of affected patients at each locus, colored by lesion category.
}
}
\description{
Generates a genome-wide lesion plot displaying all lesion types affecting different chromosomes.
}
\details{
This function uses genome-wide coordinates (from \code{compute.gw.coordinates}) to generate a three-panel plot. The middle panel shows lesions by chromosome across patients. The left panel displays the -log10(q-values) from the GRIN results for each gene, and the right panel shows the number of patients affected at each locus, color-coded by lesion type.
}
\examples{
data(lesion_data)
data(hg38_gene_annotation)
data(hg38_chrom_size)

# Run GRIN analysis
grin.results <- grin.stats(lesion_data,
                           hg38_gene_annotation,
                           hg38_chrom_size)

# Generate genome-wide lesion plot with alphabetical patient ordering
genomewide.plot <- genomewide.lsn.plot(grin.results, max.log10q = 50)
}
\references{
Cao, X., Elsayed, A. H., & Pounds, S. B. (2023). Statistical Methods Inspired by Challenges in Pediatric Cancer Multi-omics.
}
\seealso{
\code{\link{compute.gw.coordinates}}
}
\author{
Abdelrahman Elsayed \email{abdelrahman.elsayed@stjude.org} and Stanley Pounds \email{stanley.pounds@stjude.org}
}
