% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.chrom.length.R
\name{get.chrom.length}
\alias{get.chrom.length}
\title{Get Chromosome Length}
\usage{
get.chrom.length(genome.assembly)
}
\arguments{
\item{genome.assembly}{Character string specifying the genome assembly. Currently, only \code{"Human_GRCh38"} is supported.}
}
\value{
A data frame with the following columns:
\describe{
\item{chrom}{Chromosome identifier (e.g., 1, 2, ..., X, Y).}
\item{size}{Chromosome size in base pairs.}
}
}
\description{
Retrieves chromosome size data for the human GRCh38 (hg38) genome assembly using UCSC \code{chromInfo} data, accessed via the \code{circlize} package.
}
\details{
The function fetches chromosome size information from the UCSC genome browser via the \code{circlize::read.chromInfo()} function. It returns data for all 22 autosomes in addition to X and Y chromosomes in the human GRCh38 (hg38) assembly. Chromosome names are formatted without the \code{"chr"} prefix.
}
\examples{
# Retrieve chromosome size data for the GRCh38 genome assembly
hg38.chrom.size <- get.chrom.length("Human_GRCh38")
}
\references{
Cao, X., Elsayed, A. H., & Pounds, S. B. (2023). Statistical Methods Inspired by Challenges in Pediatric Cancer Multi-omics.
}
\seealso{
\code{\link[circlize]{read.chromInfo}}
}
\author{
Abdelrahman Elsayed \email{abdelrahman.elsayed@stjude.org} and Stanley Pounds \email{stanley.pounds@stjude.org}
}
