% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_manipulation.R
\name{rename_value}
\alias{rename_value}
\title{Rename Values in a Column}
\usage{
rename_value(data, column_name = NULL, mapping.file)
}
\arguments{
\item{data}{Data structure (data frame, list, or nested combination).}

\item{column_name}{Character. Column to modify. If `NULL`, the function extracts it from `mapping.file`.}

\item{mapping.file}{Data frame with `"OldName"` and `"NewName"` columns for renaming.}
}
\value{
The same data structure with specified values replaced.
}
\description{
Replaces specific values in a column based on a provided mapping file.
Supports renaming across nested data structures and preserves factor levels.
}
\examples{
# Load Data:
input_path <- system.file("extdata/in", package = "GTAPViz")
har.plot.data <- readRDS(file.path(input_path, "har.plot.data.rds"))

# Rename variables in a dataset
mapping_welfare <- data.frame(
  ColumnName = "COLUMN",
  OldName = c("alloc_A1", "ENDWB1", "tech_C1", "pop_D1", "pref_G1", "tot_E1", "IS_F1"),
  NewName = c("Alloc Eff.", "Endwb", "Tech Chg.", "Pop", "Perf", "ToT", "I-S"),
  stringsAsFactors = FALSE
)

har.plot.data <- rename_value(har.plot.data, mapping.file = mapping_welfare)
}
\seealso{
\code{\link{add_mapping_info}}, \code{\link{convert_units}}, \code{\link{sort_plot_data}}
}
\author{
Pattawee Puangchit
}
