% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2025-10-27_JF_R_Galaxy_functions.R
\name{galaxy_history_size}
\alias{galaxy_history_size}
\title{Galaxy history size
Get the disk usage / size of a Galaxy history}
\usage{
galaxy_history_size(
  history_id,
  galaxy_url = "https://usegalaxy.eu",
  include_deleted = FALSE
)
}
\arguments{
\item{history_id}{Galaxy history id (required)}

\item{galaxy_url}{Character. Base URL of the Galaxy instance
(for example \code{"https://usegalaxy.eu"}).
If the environment variable \code{GALAXY_URL} is set, it takes precedence.}

\item{include_deleted}{Logical; whether to include deleted datasets when summing (default FALSE)}
}
\value{
data.frame with columns history_id, bytes, human_size
}
\description{
The function first tries to read a size/disk_usage field from the history
summary endpoint. If that is not present it fetches the history contents
and sums dataset sizes (robust to a few different field names used by
different Galaxy versions). Results are returned as a data.frame with
bytes and a human-readable size.
}
\examples{
\dontshow{if (galaxy_has_key()) withAutoprint(\{ # examplesIf}
histories <- galaxy_list_histories()
if(nrow(histories > 0)){
  galaxy_history_size(histories$history_id[1])
} else {
  message("No histories found for current user.")
}

\dontshow{\}) # examplesIf}
}
