% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lines_GeDSMethod.R
\name{lines.GeDS}
\alias{lines.GeDS}
\title{Lines Method for GeDS Objects}
\usage{
\method{lines}{GeDS}(
  x,
  n = 3L,
  transform = function(x) x,
  onlySpline = TRUE,
  data = data.frame(),
  ...
)
}
\arguments{
\item{x}{A \code{"GeDS"} class object, as returned by \code{NGeDS()} or \code{GGeDS()}.}

\item{n}{Integer value (2, 3 or 4) specifying the order (\eqn{=} degree
\eqn{+ 1}) of the GeDS fit that should be plotted. By default equal to
\code{3L}. Non-integer values will be passed to the function
\code{\link{as.integer}}.}

\item{transform}{A function that can be used to transform the scale of the
\eqn{y}-axis. Typically it can be the inverse of the link function if the plot
is on the scale of the response variable.}

\item{onlySpline}{Logical variable specifying whether only the spline
component of the fitted GeDS predictor model  should be plotted or
alternatively also the parametric component (see
\code{\link[=formula.GeDS]{formula}}) should be plotted.}

\item{data}{An optional \code{data.frame}, \code{list}, or \code{environment}.
It should contain values of the independent variables for which the GeDS predicted
values should be plotted. If left empty, the values are extracted from the object \code{x}.}

\item{...}{Further arguments to be passed to the default
\code{\link[graphics]{lines}} function.}
}
\description{
Lines method for GeDS objects. Adds a GeDS curve to an existing plot.
}
\details{
This method can be used to add a curve corresponding to a particular GeDS fit
to an active plot.

As GeDS objects contain three different fits (linear, quadratic and cubic),
it is possible to specify the order of the GeDS regression to be plotted via
the input argument \code{n}.
}
\examples{

# Generate a data sample for the response variable
# Y and the single covariate X
set.seed(123)
N <- 500
f_1 <- function(x) (10*x/(1+100*x^2))*4+4
X <- sort(runif(N, min = -2, max = 2))
# Specify a model for the mean of Y to include only a component
# non-linear in X, defined by the function f_1
means <- f_1(X)
# Add (Normal) noise to the mean of Y
Y <- rnorm(N, means, sd = 0.1)

# Fit a GeDS regression model using NGeDS
(Gmod <- NGeDS(Y ~ f(X), beta = 0.6, phi = 0.995, Xextr = c(-2,2)))

# Plot the GeDS third order fit (the quadratic one)
# without its corresponding Polygon
plot(Gmod, type = "none")

# Add a curve corresponding to the second order fit (the linear one)
lines(Gmod, n = 2, col = "green", lwd = 2, lty = 3)

}
\seealso{
\code{\link[graphics]{lines}} for the definition of the generic
function; \code{\link{NGeDS}} and \code{\link{GGeDS}} for examples.
}
