% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ForecastHMMCdf.R
\name{ForecastHMMCdf}
\alias{ForecastHMMCdf}
\title{Forecasted cumulative distribution function of a univariate HMM at times n+k1, n+k2,....}
\usage{
ForecastHMMCdf(
  x,
  ZI = 0,
  family,
  theta,
  Q,
  eta,
  size = 0,
  k = 1,
  graph = FALSE
)
}
\arguments{
\item{x}{points at which the cdf function is computed}

\item{ZI}{1 if zero-inflated, 0 otherwise (default)}

\item{family}{distribution name; run the function distributions() for help}

\item{theta}{parameters; (r  x p)}

\item{Q}{probability transition matrix for the regimes; (r  x r)}

\item{eta}{vector of the estimated probability of each regime at time n; (1 x r)}

\item{size}{additional parameter for some discrete distributions; run the command distributions() for help}

\item{k}{prediction times}

\item{graph}{TRUE to produce plots (FALSE by default).}
}
\value{
\item{cdf}{values of the cdf function}
}
\description{
This function computes the forecasted cumulative distribution function of a univariate HMM for multiple horizons, given observations up to time n
}
\examples{
family = "gaussian"
theta = matrix(c(-1.5, 1.7, 1, 1),2,2)
Q = matrix(c(0.8, 0.3, 0.2, 0.7), 2, 2)
eta = c(0.96, 0.04)
x=seq(from=-6, to=6, by=0.1)
k=c(1,5,10,20)
cdf = ForecastHMMCdf(x, 0, family, theta, Q, eta, size=0, k, graph=TRUE)


}
