% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ForecastHMMVAR.R
\name{ForecastHMMVAR}
\alias{ForecastHMMVAR}
\title{Value at risk (VAR) of a univariate HMM at time n+k1, n+k2, ...}
\usage{
ForecastHMMVAR(U, ZI = 0, family, theta, Q, eta, k = 1)
}
\arguments{
\item{U}{values (n  x 1) between 0 and 1}

\item{ZI}{1 if zero-inflated, 0 otherwise (default)}

\item{family}{distribution name; run the function distributions() for help}

\item{theta}{parameters; (r  x p)}

\item{Q}{probability transition  matrix for the regimes; (r  x r)}

\item{eta}{vector of the estimated probability of each regime at time n; (1  x r)}

\item{k}{prediction times (may be a vector of integers).}
}
\value{
\item{var}{values at risk (1 x horizon)}
}
\description{
This function computes the VAR of a univariate HMM for multiple horizons, given observations up to time n
}
\examples{
\donttest{
family = "gaussian"
theta = matrix(c(-1.5, 1.7, 1, 1),2,2)
Q = matrix(c(0.8, 0.3, 0.2, 0.7), 2, 2)
eta = c(0.96, 0.04)
U=c(0.01,0.05)
k=c(1,2,3,4,5)
ForecastHMMVAR(U, 0, family, theta, Q, eta=eta,k)
}



}
