% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{json_schema_validator}
\alias{json_schema_validator}
\title{simple way to validate a json instance under a given schema}
\usage{
json_schema_validator(json_data = NULL, json_schema = NULL)
}
\arguments{
\item{json_data}{a named list specifying the input data to validate against the json-schema}

\item{json_schema}{a named list specifying the json-schema}
}
\description{
simple way to validate a json instance under a given schema
}
\details{
Define a json-schema that the input data should follow and then validate the input data against the schema. If the input data follows the schema then by running the function
nothing will be returned, otherwise an error with Traceback will be printed in the R-session.

In case that \emph{type} is at the same time also a property name in the json data, then do not include \emph{"type" = "string"} in the json schema ( https://github.com/epoberezkin/ajv/issues/137 )
}
\examples{

try({
  if (reticulate::py_available(initialize = FALSE)) {
    if (reticulate::py_module_available("jsonschema")) {

      library(GeoMongo)

      schema_dict = list("type" = "object",

                         "properties" = list(

                           "name" = list("type" = "string"),

                           "location" = list("type" = "object",

                                             "properties" = list(

                                               "type" = list("enum" = c("Point", "Polygon")),

                                               "coordinates" = list("type" = "array")
                                             ))))


      data_dict = list("name" = "example location",

                       "location" = list("type" = "Point", "coordinates" = c(-120.24, 39.21)))


      json_schema_validator(json_data = data_dict, json_schema = schema_dict)
    }
  }
}, silent=TRUE)
}
\references{
https://pypi.org/project/jsonschema/, https://python-jsonschema.readthedocs.io/en/latest/
}
