% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{matern15_isotropic}
\alias{matern15_isotropic}
\title{Isotropic Matern covariance function, smoothness = 1.5}
\usage{
matern15_isotropic(covparms, locs)
}
\arguments{
\item{covparms}{A vector with covariance parameters
in the form (variance, range, nugget)}

\item{locs}{A matrix with \code{n} rows and \code{d} columns.
Each row of locs is a point in R^d.}
}
\value{
A matrix with \code{n} rows and \code{n} columns, with the i,j entry
containing the covariance between observations at \code{locs[i,]} and
\code{locs[j,]}.
}
\description{
From a matrix of locations and covariance parameters of the form
(variance, range, nugget), return the square matrix of
all pairwise covariances.
}
\section{Parameterization}{

The covariance parameter vector is (variance, range, nugget)
= \eqn{(\sigma^2,\alpha,\tau^2)}, and the covariance function is parameterized
as
\deqn{ M(x,y) = \sigma^2 (1 + || x - y || ) exp( - || x - y ||/ \alpha )}
The nugget value \eqn{ \sigma^2 \tau^2 } is added to the diagonal of the covariance matrix.
NOTE: the nugget is \eqn{ \sigma^2 \tau^2 }, not \eqn{ \tau^2 }.
}

