% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est.prop.R
\name{est.prop}
\alias{est.prop}
\title{Proportion Estimation}
\usage{
est.prop(p.value, cn, adj = TRUE)
}
\arguments{
\item{p.value}{A sequence of p-values from test data, not including p-values from covariates.}

\item{cn}{A value of bounding sequence generated by HCTR::bounding.seq().}

\item{adj}{A boolean algebra to decide whether to use adjusted Higher Criticism test statistic, the default value is TRUE.}
}
\value{
An estimated proportion of false null hypothesis.
}
\description{
Estimates false null hypothesis Proportion from multiple p-values using higher criticism test estimator.
}
\examples{
set.seed(10)
X <- matrix(runif(n = 10000, min = 0, max = 1), nrow = 100)
result <- bounding.seq(p.value = X)
Y <- matrix(runif(n = 100, min = 0, max = 1), nrow = 100)
test <- est.prop(p.value = Y, cn = result)

}
\references{
\insertRef{meinshausen2006estimating}{HCTR}
}
