% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_trend_table.R
\name{read_trend_table}
\alias{read_trend_table}
\title{Read HCUP Summary Trend Table from Disk}
\usage{
read_trend_table(
  file_path = NULL,
  table_id = NULL,
  sheet = NULL,
  clean_names = TRUE,
  as_data_table = NULL,
  name = NULL
)
}
\arguments{
\item{file_path}{Optional character string, path to a trend table Excel file (.xlsx).
If NULL (default), automatically searches the cache directory for files
downloaded via \code{download_trend_tables()} and shows an interactive menu.}

\item{table_id}{Optional character string, table ID (e.g., "1", "2a", "2b") to
read from cache. Only used when \code{file_path} is NULL. If both are NULL, shows
interactive menu.}

\item{sheet}{Character string or integer specifying which sheet to read. If
NULL (default), shows an interactive menu to select a sheet (in interactive sessions),
or automatically selects the "National" sheet (or first data sheet) in non-interactive sessions.
Common sheet names include "National", "Regional", "State", etc.}

\item{clean_names}{Logical. If TRUE (default), column names are cleaned to
follow R naming conventions (snake_case).}

\item{as_data_table}{Logical or NULL. If TRUE and the \code{data.table} package is
available, returns a \code{data.table} object instead of a tibble. If FALSE,
returns a tibble. If NULL (default), prompts the user interactively to
choose (only in interactive sessions). In non-interactive sessions, defaults
to FALSE. Note: tibbles are already data frames and work with all standard
R data frame operations.}

\item{name}{Optional character string, suggested variable name for the
returned data. This is only used for display/messaging purposes and does
not automatically assign the data to a variable. You must still assign the
result: \code{my_data <- read_trend_table()}. If NULL (default), a name is
suggested based on the table ID and sheet.}
}
\value{
A tibble (or data.table if \code{as_data_table = TRUE}) containing the
trend table data. Tibbles are data frames and can be used with all
standard R data frame operations, including \code{dplyr}, \code{data.table}, and
base R functions.
}
\description{
Reads a previously downloaded HCUP Summary Trend Table Excel file from disk.
If no file path is provided, automatically finds and reads cached files from
\code{download_trend_tables()}, with an interactive menu to select from available
tables.
}
\details{
HCUP Summary Trend Tables are Excel files with multiple sheets containing
data at different geographic levels (National, Regional, State). Use the
\code{sheet} parameter to specify which sheet to read, or call the function
multiple times with different sheets.

When \code{file_path} is NULL, the function automatically searches the cache
directory (\code{tempdir()}) for files matching the pattern \code{HCUP_SummaryTrendTables_*.xlsx}.
If multiple files are found, an interactive menu is displayed for selection.

To see available sheets, use \code{list_trend_table_sheets()}.
}
\note{
To use the data, assign it to a variable:
\code{my_data <- read_trend_table()}. The \code{name} parameter is only for display
purposes and does not automatically assign the data.
}
\examples{
\donttest{
# Automatically read from cache (shows menu if multiple files)
# Assign to a variable to use the data
national_data <- read_trend_table()

# Read specific table from cache with suggested name
table_2a <- read_trend_table(table_id = "2a", name = "table_2a")

# Read from a specific file path (manual)
national_data <- read_trend_table("path/to/HCUP_SummaryTrendTables_T2a.xlsx")

# Read a specific sheet with custom name
state_data <- read_trend_table(
  "path/to/HCUP_SummaryTrendTables_T2a.xlsx",
  sheet = "State",
  name = "state_data"
)

# List available sheets first
sheets <- list_trend_table_sheets("path/to/HCUP_SummaryTrendTables_T2a.xlsx")
print(sheets)

# Use the data after assignment
head(national_data)
nrow(national_data)
}

}
