% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HDSpatialScan_plotCurves.R
\name{plotCurves.ResScanOutputUniFunct}
\alias{plotCurves.ResScanOutputUniFunct}
\title{Plots the curves in the clusters detected by the univariate functional scan functions (PFSS, NPFSS, DFFSS or URBFSS)}
\usage{
\method{plotCurves}{ResScanOutputUniFunct}(
  x,
  add_mean = FALSE,
  add_median = FALSE,
  colors = "red",
  only.MLC = FALSE,
  ...
)
}
\arguments{
\item{x}{ResScanOutputUniFunct. Output of a univariate functional scan function (PFSS, NPFSS, DFFSS or URBFSS).}

\item{add_mean}{boolean. If TRUE it adds the global mean curve in black.}

\item{add_median}{boolean. If TRUE it adds the global median curve in blue.}

\item{colors}{character. The colors to plot the clusters' curves. If length(colors)==1 then all the clusters will be plotted in this color. Else there must be the same number of elements in colors than the number of clusters}

\item{only.MLC}{logical. Should we plot only the MLC or all the significant clusters?}

\item{...}{Further arguments to be passed to or from methods.}
}
\value{
No value returned, plots the curves.
}
\description{
This function plot the curves in the clusters detected by the univariate functional scan functions (PFSS, NPFSS, DFFSS or URBFSS).
}
\examples{
\donttest{
library(sp)
data("map_sites")
data("funi_data")
coords <- coordinates(map_sites)

res_npfss <- SpatialScan(method = "NPFSS", data = funi_data, sites_coord = coords,
system = "WGS84", mini = 1, maxi = nrow(coords)/2)$NPFSS

plotCurves(x = res_npfss, add_mean = TRUE, add_median = TRUE)}
\dontshow{
library(sp)
data("map_sites")
data("funi_data")
indices <- c(51:75)
coords <- coordinates(map_sites[indices,])
res_npfss <- SpatialScan(method = "NPFSS", data = funi_data[indices,],
sites_coord = coords,
system = "WGS84", mini = 1, maxi = nrow(coords)/2, MC = 99)$NPFSS
if(length(res_npfss$sites_clusters)>0){
plotCurves(x = res_npfss, add_mean = TRUE, add_median = TRUE)
}

}

}
