% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smplSizPred.R
\name{smplSizPred}
\alias{smplSizPred}
\title{Predict Number of Replicates Based on Heritability, Power, and Fold Change}
\usage{
smplSizPred(
  df4model = df4modelInpt,
  hIndexMeanDFinput = hIndexMeanDF,
  heritabilityClass,
  inptPwr,
  fc,
  trait = NULL,
  tissue = NULL
)
}
\arguments{
\item{df4model}{A data frame containing the input data for the model. It should include the following columns: \code{NoOfReplicates}, \code{HeritabilityValue}, \code{pwr}, \code{FoldChange}, and optionally \code{Tissue}.}

\item{hIndexMeanDFinput}{A data frame containing the mean heritability values for each trait. It should include at least the columns \code{Trait.name} and \code{MeanValue}.}

\item{heritabilityClass}{A character string specifying the heritability class used for filtering and adjusting the prediction. Possible values are "low", "mid", and "high".}

\item{inptPwr}{A numeric value representing the power used in the model.}

\item{fc}{A numeric value representing the fold change used in the model.}

\item{trait}{An optional parameter specifying the trait. If provided, the heritability value for the trait will be used to adjust the heritability class values.}

\item{tissue}{An optional parameter specifying the tissue type. If provided, the model will include tissue as a factor in the regression. If not provided, tissue is excluded.}
}
\value{
A numeric value representing the predicted number of replicates. The value is rounded to the nearest whole number and adjusted to ensure it is valid for the selected heritability class.
}
\description{
This function predicts the number of replicates required for a given experiment based on heritability, power, fold change, and tissue type. The model is constructed using the provided data, and the prediction is adjusted based on the selected trait's mean heritability value. The function ensures that the predicted replicates are valid, rounding negative or unrealistic values to sensible minimums based on the heritability class.
}
\examples{
\donttest{
# Example usage:
df4modelInpt <- data.frame(
    NoOfReplicates = c(3, 5, 7, 9, 11),
    HeritabilityClass = c("high", "mid", "low", "high", "mid"),
    HeritabilityValue = c(0.5, 0.6, 0.7, 0.5, 0.6),
    pwr = c(0.8, 0.9, 0.85, 0.88, 0.86),
    FoldChange = c(2, 3, 2.5, 2.8, 3.2),
    Tissue = c("Liver", "Liver", "Kidney", "Liver", "Kidney")
)
hIndexMeanDF <- data.frame(Trait.name = c("Trait1", "Trait2"),
                           MeanValue = c(0.3, 0.5))
NoOfReplicatesPred <- smplSizPred(df4model = df4modelInpt,
                      hIndexMeanDFinput = hIndexMeanDF,
                      heritabilityClass = "mid",
                      inptPwr = 0.85,
                      fc = 2.5,
                      trait = "Trait1",
                      tissue = "Liver")
print(NoOfReplicatesPred)
}

}
\references{
Sun et al. (2017) \doi{10.1093/nar/gkx204}
}
