% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull_resid.R
\name{pull_resid.default}
\alias{pull_resid.default}
\alias{pull_resid.lmerMod}
\alias{pull_resid}
\alias{pull_resid.lme}
\title{Computationally Efficient HLM Residuals}
\usage{
\method{pull_resid}{default}(object, ...)

\method{pull_resid}{lmerMod}(object, type = "ls", standardize = FALSE, ...)

\method{pull_resid}{lme}(object, type = "ls", standardize = FALSE, ...)
}
\arguments{
\item{object}{an object of class \code{lmerMod} or \code{lme}.}

\item{...}{not in use}

\item{type}{which residuals should be returned. Can be either 'ls', 'eb', or
'marginal'}

\item{standardize}{a logical indicating if residuals should be standardized}
}
\description{
\code{pull_resid} takes a hierarchical linear model fit as a \code{lmerMod}
or \code{lme} object and returns various types of level-1 residuals as a
vector. Because the \code{pull_resid} only calculates one type of residual,
it is more efficient than using \code{\link{hlm_resid}} and indexing the
resulting tibble. \code{pull_resid} is designed to be used with methods that
take a long time to run, such as the resampling methods found in the
\code{lmeresampler} package.
}
\details{
\describe{
\item{\code{type = "ls"}}{Residuals calculated by fitting separate LS
regression models for each group. LS residuals are unconfounded by higher
level residuals, but unreliable for small within-group sample sizes. When
\code{standardize = TRUE}, residuals are standardized by sigma components of
the model object.}
\item{\code{type = "eb"}}{Residuals calculated using the empirical Bayes (EB)
method using maximum likelihood. EB residuals are interrelated with higher
level residuals. When \code{standardize = TRUE}, residuals are standardized
by sigma components of the model object.}
\item{\code{type = "marginal"}}{Marginal residuals only consider the fixed
effect portion of the estimates. When \code{standardize = TRUE}, Cholesky
residuals are returned.}
}
}
\seealso{
\link[HLMdiag]{hlm_resid}
}
