% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n_freeman2000.R
\name{n_freeman2000}
\alias{n_freeman2000}
\title{Compute hydraulic roughness due to vegetation following Freeman, Rahymeyer, and Copeland (2000)}
\usage{
n_freeman2000(depth, slope, area, hp, hlm, We, Ds, pnum, snum, restrict = TRUE)
}
\arguments{
\item{depth}{flow depth (H) in meters. Assumes wide channel geometry where depth
is approximately equal to hydraulic radius.}

\item{slope}{channel bed slope (S)}

\item{area}{sample vegetative plot bed area in square meters, a list of index 5}

\item{hp}{average plant height (h_p) in meters, a list of index 5}

\item{hlm}{average leaf mass height (hlm) in meters, a list of index 5}

\item{We}{average leaf mass width (We) in meters, a list of index 5}

\item{Ds}{average stem diameter (Ds) in meters, a list of index 5}

\item{pnum}{number of plants in the corresponding indices, a list of index 5}

\item{snum}{number of stems at H/4 in the corresponding indices, a list of index 5}

\item{restrict}{allows for function parameters to restrict certain values. Type bool. Default TRUE.}
}
\value{
Manning's n
}
\description{
\code{n_freeman2000} calculate Manning's n using the Freeman, Rahymeyer, and
Copeland (2000) method for estimating vegetative roughness
}
\examples{
# Result: Manning's n of 0.013
depth <- 6
slope <- 0.005
area <- 100
hp <- c(0.51,0.71,0.2,0.97,0.71)
hlm <- c(0.45,0.71,0.16,0.9,0.62)
We <- c(0.229,0.356,0.254,0.482,0.178)
Ds <- c(0.0095,0.0095,0.0063,0.0252,0.0063)
pnum <- c(2,2,2,1,3)
snum <- c(1,1,2,2,6)
n_freeman2000(depth,slope,area,hp,hlm,We,Ds,pnum,snum)

# Result: Manning's n of 0.0183
depth <- 0.3
slope <- 0.005
area <- 100
hp <- c(0.51,0.71,0.2,0.97,0.71)
hlm <- c(0.45,0.71,0.16,0.9,0.62)
We <- c(0.229,0.356,0.254,0.482,0.178)
Ds <- c(0.0095,0.0095,0.0063,0.0252,0.0063)
pnum <- c(2,2,2,1,3)
snum <- c(1,1,2,2,6)
n_freeman2000(depth,slope,area,hp,hlm,We,Ds,pnum,snum)

# Result: Vegetation height must be positive.
depth <- 0.3
slope <- 0.005
area <- 100
hp <- c(0.51,0.71,0.2,0.97,-0.23)
hlm <- c(0.45,0.71,0.16,0.9,0.62)
We <- c(0.229,0.356,0.254,0.482,0.178)
Ds <- c(0.0095,0.0095,0.0063,0.0252,0.0063)
pnum <- c(2,2,2,1,3)
snum <- c(1,1,2,2,6)
n_freeman2000(depth,slope,area,hp,hlm,We,Ds,pnum,snum)

}
\references{
Freeman, G. E., W. H. Rahmeyer, and R. R. Copeland. 2000. Determination of
Resistance Due to Shrubs and Woody Vegetation. ERDC/CHL TR-00-25. U.S.
Army Engineer Research and Development Center, Vicksburg, Mississippi.
}
