% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envelope.R
\name{envelope.HZIP}
\alias{envelope.HZIP}
\title{Envelope simulation for HZIP Model}
\usage{
envelope.HZIP(object, nsim = 100, ...)
}
\arguments{
\item{object}{An object of class \code{HZIP}, typically returned by \code{\link{hzip}}.}

\item{nsim}{Integer. Number of simulations used to construct the envelope. Default is \code{100}.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
Envelope simulation plot.
}
\description{
Produces a Q-Q plot of residuals from a Hierarchical Zero-Inflated Poisson (HZIP) Model fitted via \code{\link{hzip}}.
}
\details{
A simulation envelope is added using Monte Carlo replications.
}
\examples{
\donttest{
data(salamanders)
fit.salamander <- hzip(y ~ mined|mined+spp,data = salamanders)
res <- residuals(fit.salamander)
envelope.HZIP(res, nsim = 21)
}

}
\seealso{
\code{\link{hzip}}, \code{\link{residuals.HZIP}}
}
