% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_cooper.R
\name{get_cooper}
\alias{get_cooper}
\title{get_cooper}
\usage{
get_cooper(x)
}
\arguments{
\item{x}{integer
Hadamard Matrix Order to Check}
}
\value{
m Tsequence order

n Williamson  order
}
\description{
This function provides the Williamson Matrix order and T-Sequence length required to construct Hadamard matrix.
}
\details{
If m is the order of T-Sequence and n is the order of Williamson sequence and both exists.
Cooper and Wallis (1972) showed a construction method for Hadamard matrix of order 4mn exists. This function returns
m and n if they exists otherwise NULL value is returned.
}
\examples{
get_cooper(340)
#$m
#[1] 5
#$n
#[1] 17
get_cooper(256)
#NULL
}
\references{
Cooper, J., and Wallis, J. 1972. A construction for Hadamard arrays. Bull. Austral. Math. Soc., 07: 269-277.
}
