% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draft.R
\name{hapiBlockMPR}
\alias{hapiBlockMPR}
\title{Maximum Parsimony of Recombination (MPR) for 
proofreading of draft haplotypes}
\usage{
hapiBlockMPR(draftHap, gmtFrame, cvlink = 2, smallBlock = 100)
}
\arguments{
\item{draftHap}{a dataframe with draft haplotype information}

\item{gmtFrame}{a dataframe of raw genotype data in the framework}

\item{cvlink}{a numeric value of number of cvlinks. Default is \code{2}}

\item{smallBlock}{a numeric value determining the size of small blocks 
that should be excluded from the draft haplotypes}
}
\value{
a dataframe of draft haplotypes after proofreading
}
\description{
Maximum Parsimony of Recombination (MPR) for 
proofreading of draft haplotypes
}
\examples{
ref <- rep(0,500)
alt <- rep(1,500)

gmtFrame <- data.frame(gmt1=ref, gmt2=alt, gmt3=ref,
gmt4=ref, gmt5=c(alt[1:250], ref[251:500]),
stringsAsFactors = FALSE)

idx1 <- sort(sample(seq_len(500), 30, replace = FALSE))
idx2 <- sort(sample(seq_len(500), 30, replace = FALSE))
idx3 <- sort(sample(seq_len(500), 30, replace = FALSE))

gmtFrame[idx1,1] <- NA
gmtFrame[idx2,2] <- NA
gmtFrame[idx3,3] <- NA

imputedFrame <- data.frame(gmt1=ref, gmt2=alt, gmt3=ref,
gmt4=ref, gmt5=c(alt[1:250], ref[251:500]),
stringsAsFactors = FALSE)

draftHap <- hapiPhase(imputedFrame)

finalDraft <- hapiBlockMPR(draftHap, gmtFrame, cvlink=2, smallBlock=100)
}
\author{
Ruidong Li
}
