% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draft.R
\name{hapiCVCluster}
\alias{hapiCVCluster}
\title{Filter out hetSNPs in potential complex regions}
\usage{
hapiCVCluster(draftHap, minDistance = 1e+06, cvlink = 2)
}
\arguments{
\item{draftHap}{a dataframe with draft haplotype information}

\item{minDistance}{a numeric value of the distance between two 
genomic positions with cv-links. Default is \code{1000000}}

\item{cvlink}{a numeric value of number of cvlinks. Default is \code{2}}
}
\value{
a dataframe of regions to be filtered out
}
\description{
Filter out hetSNPs in potential complex regions
}
\examples{
ref <- rep(0,500)
alt <- rep(1,500)

imputedFrame <- data.frame(gmt1=ref, gmt2=alt, gmt3=ref,
gmt4=ref, gmt5=c(alt[1:250], ref[251:500]),
stringsAsFactors = FALSE)

draftHap <- hapiPhase(imputedFrame)
cvCluster <- hapiCVCluster(draftHap = draftHap, cvlink=2)
}
\author{
Ruidong Li
}
