% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic.R
\name{num2base}
\alias{num2base}
\title{Convert genotype coded in 0/1 to A/T/C/G}
\usage{
num2base(hap, ref, alt)
}
\arguments{
\item{hap}{a dataframe of consensus haplotypes}

\item{ref}{a character represents reference allele}

\item{alt}{a character represents alternative allele}
}
\value{
a dataframe containing converted haplotypes
}
\description{
Convert numeric (0/1) coded genotype to base (A/T/C/G) coded
}
\examples{
ref <- sample(c('A','T'),500, replace=TRUE)
alt <- sample(c('C','G'),500, replace=TRUE)

consensusHap <- data.frame(hap1=rep(0,500),hap2=rep(1,500),
    total=rep(5,500),rate=rep(1,500),
    confidence=rep('F',500),
    stringsAsFactors = FALSE)
rownames(consensusHap) <- seq_len(500)

hap <- num2base(hap=consensusHap, ref=ref, alt=alt)
}
\author{
Ruidong Li
}
