% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coralPreprocess.R
\name{coralPreprocess}
\alias{coralPreprocess}
\title{coralPreprocess}
\usage{
coralPreprocess(
  Y,
  spNames.common,
  TrData = NULL,
  phyloTree = NULL,
  Taxa = NULL,
  TaxaFormula = NULL
)
}
\arguments{
\item{Y}{community matrix of both common and rare species}

\item{spNames.common}{vector of species that are considered common in CORAL analysis}

\item{TrData}{trait matrix for both common and rare species}

\item{phyloTree}{phylogeny tree covering both common and rare species}

\item{Taxa}{dataframe with}

\item{TaxaFormula}{formula for calculating phylogeny from taxonomy, as in \code{as.phylo.formula(...)}}
}
\value{
A named list containing \code{Y.xyz} and \code{TrData.xyz} parts for common and rare partitions,
phylogeny tree \code{phyloTree.common} for common part and
phylogeny similarity matrix \code{C.common.rare} between common and rare species
}
\description{
Splits typical Hmsc data into common and rare partitions for CORAL analysis
}
\details{
This functions implies that all column names of \code{Y} that are not listed in \code{spNames.common} argument
are considered rare species in the context of CORAL analysis.

Exactly one argument of phyloTree and Taxa must be specified.
}
