% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fooSatpDs.R
\name{TSats}
\alias{TSats}
\title{Saturation Temperature, Function of Entropy}
\usage{
TSats(s, digits = 9)
}
\arguments{
\item{s}{Entropy [kJ kg-1 K-1]}

\item{digits}{Digits of results (optional)}
}
\value{
The Saturation Temperature: Tsat [ K ] and an Error Message 
    (if an error occur: \link{errorCodes})
}
\description{
The function \code{TSats(s,digits=9)} returns the temperature [K], 
     TSat, for given s [kJ kg-1 K-1].
}
\details{
This function calls a Fortran DLL that solves the Helmholtz Energy Equation. 
    in accordance with the Revised Release on the IAPWS Formulation 1995 for the 
    Thermodynamic Properties of Ordinary Water Substance for General and Scientific
    Use (June 2014) developed by the International Association for the Properties of
    Water and Steam,  \url{https://iapws.org/relguide/IAPWS-95.html}. It is valid  
    from the triple point to the pressure of 1000 MPa and temperature of 1273.
}
\examples{
s <- 2.10865845
T_Sat <- TSats(s)
T_Sat

}
