% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fooSatT.R
\name{ufT}
\alias{ufT}
\title{Saturated Liquid Specific Internal Energy, Function of Temperature}
\usage{
ufT(Temp, digits = 9)
}
\arguments{
\item{Temp}{Temperature [ K ]}

\item{digits}{Digits of results (optional)}
}
\value{
The saturated liquid internal energy: uf [kJ kg-1] and an Error
     Message (if an error occur: \link{errorCodes})
}
\description{
The function \code{ufT(Temp,digits=0).} returns the saturated liquid internal energy [kJ kg-1], 
    uf, for given Temp [K].
}
\details{
This function calls a Fortran DLL that solves the Helmholtz Energy Equation. 
    in accordance with the Revised Release on the IAPWS Formulation 1995 for the 
    Thermodynamic Properties of Ordinary Water Substance for General and Scientific
    Use (June 2014) developed by the International Association for the Properties of
    Water and Steam,  \url{https://iapws.org/relguide/IAPWS-95.html}. It is valid  
    from the triple point to the pressure of 1000 MPa and temperature of 1273.
}
\examples{
Temp <- 450.
uf <- ufT(Temp)
uf

}
