% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RMM.R
\name{RMM}
\alias{RMM}
\title{Row Minimum Method}
\usage{
RMM(ex_matrix)
}
\arguments{
\item{ex_matrix}{A cost matrix where last column must be the supply and last row must be the demand. Input matrix should not have any missing values (NA), otherwise function will throw an error. It should be balanced i.e. total demand must be equal to total supply.}
}
\value{
A List which contain the allocation matrix and the total optimized cost.
}
\description{
In the row minimum method, the first row that is the lowest cost cell is exhausted. The objective is to allocate the maximum either at the first source or demand at the destinations or to satisfy both. This process must be continued for all the other reduced transportation costs until and unless the supply and demand are satisfied.
}
\examples{
#Input matrix where last row is the Demand and last column is the Supply
ex_matrix=data.frame(D1=c(6,3,4,20),E1=c(4,8,4,95),F1=c(1,7,2,35),
                     Supply=c(50,40,60,150),row.names = c("A1","B1","C1","Demand"))
RMM(ex_matrix)

}
