% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{pred_refit_panel}
\alias{pred_refit_panel}
\title{Refitted Predictive Model for a Given Panel}
\usage{
pred_refit_panel(
  pred_first = NULL,
  gene_lengths = NULL,
  model = "T",
  genes,
  biomarker = "TMB",
  marker_mut_types = c("NS", "I"),
  training_data = NULL,
  training_values = NULL,
  mutation_vector = NULL,
  t_s = NULL
)
}
\arguments{
\item{pred_first}{(list)
A first-fit predictive model as produced by pred_first_fit().}

\item{gene_lengths}{(dataframe)
A dataframe of gene lengths (see example_maf_data$gene_lengths for format).}

\item{model}{(character)
A choice of "T", "OLM" or "Count" specifying how predictions should be made.}

\item{genes}{(character)
A vector of gene names detailing the panel being used.}

\item{biomarker}{(character)
If "TMB" or "TIB", automatically defines marker_mut_types, otherwise this will
need to be specified separately.}

\item{marker_mut_types}{(character)
A vector specifying which mutation types groups determine the biomarker in question.}

\item{training_data}{(list)
Training data, as produced by get_mutation_tables() (select train, val or test).}

\item{training_values}{(dataframe)
Training true values, as produced by get_biomarker_tables() (select train, val or test).}

\item{mutation_vector}{(numeric)
Optional vector specifying the values of the training matrix (training_data$matrix) in
vector rather than matrix form.}

\item{t_s}{(numeric)
Optional vector specifying the frequencies of different mutation types.}
}
\value{
A list with three elements:
\itemize{
\item fit, a list including a sparse matrix 'beta' giving prediction weights.
\item panel_genes, a sparse (logical) matrix giving the genes included in prediction.
\item panel_lengths, a singleton vector giving the length of the panel used.
}
}
\description{
A function taking the output of a call to pred_first_fit(), as well as gene length information, and a specified panel (list of genes), and producing a refitted predictive model on that given panel.
}
\examples{
example_refit_panel <- pred_refit_panel(pred_first = example_first_pred_tmb,
  gene_lengths = example_maf_data$gene_lengths, genes = paste0("GENE_", 1:10))
}
