% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/additivityLineup.R
\name{additivityLineup}
\alias{additivityLineup}
\title{Lineup plot for additivity}
\usage{
additivityLineup(
  backfit_obj,
  fitMethod,
  realICE,
  figs = 10,
  colorvecfcn,
  usecolorvecfcn_inreal = FALSE,
  null_predictfcn,
  ...
)
}
\arguments{
\item{backfit_obj}{An object of class \code{backfitter}.}

\item{fitMethod}{A function that accepts \code{X} and \code{y} and returns a fitted model.}

\item{realICE}{The \code{ice} object for the real data.}

\item{figs}{The total number of plots in the lineup (including the real one). Default is 10.}

\item{colorvecfcn}{Optional function to generate a color vector for the curves.}

\item{usecolorvecfcn_inreal}{If \code{TRUE}, use \code{colorvecfcn} for the real plot.}

\item{null_predictfcn}{Optional prediction function for the null models.}

\item{...}{Additional arguments passed to \code{plot.ice}.}
}
\value{
An object of class \code{additivityLineup} (invisibly).
}
\description{
This function creates a lineup plot to assess the additivity of a predictor's effect.
It uses a nonparametric bootstrap approach to generate null plots.
}
