% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatters.R
\name{ICS_ucov}
\alias{ICS_ucov}
\alias{ICS_scov}
\title{Simple robust estimates of scatter for ICS}
\usage{
ICS_scov(x, location = TRUE, beta = 0.2)

ICS_ucov(x, location = TRUE, beta = 0.2)
}
\arguments{
\item{x}{a numeric matrix or data frame.}

\item{location}{a logical indicating whether to include the sample
mean as location estimate (defaults to \code{TRUE}).}

\item{beta}{a positive numeric value specifying the tuning parameter of the
estimator (default to 0.2), see \code{\link{ucov}()}.}
}
\value{
An object of class \code{"ICS_scatter"} with the following
components:
\item{location}{if requested, a numeric vector giving the location estimate.}
\item{scatter}{a numeric matrix giving the estimate of the scatter matrix.}
\item{label}{a character string providing a label for the scatter matrix.}
}
\description{
Wrapper functions for the one-step M-estimator of scatter with weights based
on Mahalanobis distances as computed by \code{\link{scov}()}, or the simple
related estimator that is based on a transformation as computed by
\code{\link{ucov}()}.
}
\seealso{
\code{\link[ICS]{ICS}()}

\code{\link{tcov}()}, \code{\link{ICS_tcov}()}, \code{\link{ucov}()}
}
\author{
Andreas Alfons
}
