% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{mclust_clust}
\alias{mclust_clust}
\alias{rmclust_clust}
\title{Model-Based Clustering}
\usage{
mclust_clust(X, k, clusters_only = FALSE, ...)

rmclust_clust(X, k, clusters_only = FALSE, ...)
}
\arguments{
\item{X}{a numeric matrix or data frame of the data. It corresponds to the
argument \code{data}.}

\item{k}{the number of clusters searched for. It corresponds to the argument
\code{G} of function \code{\link[mclust:Mclust]{mclust::Mclust()}}.}

\item{clusters_only}{boolean. If \code{TRUE} only the partition of the data
is returned as a vector. If \code{FALSE} the usual output of the
\code{\link[mclust:Mclust]{mclust::Mclust()}} function is returned.}

\item{...}{other arguments to pass to \code{\link[mclust:Mclust]{mclust::Mclust()}}.}
}
\value{
If \code{clusters_only} is \code{TRUE} a vector of the new partition
of the data is returned, i.e a vector of integers (from \code{1:k})
indicating the cluster to which each observation is allocated.
0 indicates trimmed observations.

Otherwise a list is returned with the following components:
\item{clust_method}{the name of the clustering method, i.e "rimle".}
\item{clusters}{the vector of the new partition of the data, i.e a vector of
integers (from \code{1:k}) indicating the cluster to which each observation
is allocated.
0 indicates outlying observations for \code{\link[=rmclust_clust]{rmclust_clust()}} only.}
\item{...}{an object of class "\code{mclust}"}
}
\description{
Wrapper for performing Model-Based Clustering from \code{\link[mclust:Mclust]{mclust::Mclust()}}
allowing noise or not.
}
\details{
\itemize{
\item \code{\link[=mclust_clust]{mclust_clust()}}: does not allow noise
\item \code{\link[=rmclust_clust]{rmclust_clust()}}: allows noise
}
}
\examples{
mclust_clust(iris[,1:4], k = 3, clusters_only = TRUE)
}
\seealso{
\code{\link[mclust:Mclust]{mclust::Mclust()}}
}
\author{
Aurore Archimbaud
}
