% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICS_S3.R
\name{plot.ICS-S3}
\alias{plot.ICS-S3}
\alias{plot.ICS}
\title{Scatterplot Matrix of Component Scores from the ICS Transformation}
\usage{
\method{plot}{ICS}(x, select = NULL, index = NULL, ...)
}
\arguments{
\item{x}{an object inheriting from class \code{"ICS"} containing results
from an ICS transformation.}

\item{select}{an integer, character, or logical vector specifying which
components to plot. If \code{NULL}, all components are plotted if there are
at most six components, otherwise the first three and the last three
components are plotted (as the components with extreme generalized kurtosis
values are the most interesting ones).}

\item{index}{an integer vector specifying which components to plot, or
\code{NULL} to plot all components.  Note that \code{index} is deprecated
and may be removed in the future, use \code{select} instead.}

\item{\dots}{additional arguments to be passed down to
\code{\link[graphics]{pairs}()}.}
}
\description{
Produces a scatterplot matrix of the component scores of an invariant
coordinate system obtained via an ICS transformation.
}
\examples{
data("iris")
X <- iris[,-5]
out <- ICS(X)
plot(out)
plot(out, select = c(1,4))

}
\seealso{
\code{\link{ICS}()}

\code{\link{gen_kurtosis}()}, \code{\link[=coef.ICS]{coef}()},
\code{\link{components}()}, and \code{\link[=fitted.ICS]{fitted}()} methods
}
\author{
Andreas Alfons and Aurore Archimbaud
}
