% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICV.R
\name{mixnorm}
\alias{mixnorm}
\title{Generating a random sample from the specified mixture of normal distributions.}
\usage{
mixnorm(n, w, mu, sdev)
}
\arguments{
\item{n}{desired sample size,}

\item{w}{vector of weighs (positive numbers between 0 and 1 that add up to one),}

\item{mu}{vector of means,}

\item{sdev}{vector of standard deviations.}
}
\value{
A random sample of size \eqn{n} from the specified mixture of normals.
}
\description{
Generating a random sample of size \eqn{n} from the normal mixture defined by  expression (2.3) of Marron and Wand (1992).
}
\details{
Producing a random sample of size \eqn{n} from the normal mixture defined by the vector of weights \eqn{w}, the vector of means \eqn{\mu}, and the vector of standard deviations \eqn{\sigma}. See Marron and Wand (1992). It is assumed that the normals are defined as parsimonious as possible. The normal distributions in the mixture should be ordered such that the means in \eqn{\mu} are arranged in a nondecreasing order.
}
\examples{
\dontrun{
# Generating a sample of size n=300 from the separated bimodal density of Marron and Wand (1992).
w=c(0.5,0.5)
mu=c(-3/2,3/2)
sdev=c(1/2,1/2)
dat=mixnorm(300,w,mu,sdev) # generated data vector
arg=seq(-4,4,len=1000)  # argument
f=w[1]*dnorm(arg,mu[1],sd=sdev[1])+w[2]*dnorm(arg,mu[2],sd=sdev[2])     # true density
dev.new()
hist(dat,freq=F,ylab="",main="",cex.lab=1.7,cex.axis=1.7,xlim=c(-4,4),lwd=2,ylim=c(0,0.45),
col='grey')
title(main="Separated bimodal density",cex.main=1.7)
legend(-5,0.4,legend="n=300",cex=2,bty="n")
lines(arg,f,lwd=3,'l')
}
}
\references{
Marron, J.S., Wand, M.P. (1992). Exact Mean Integrated Squared Error. \emph{The Annals of Statistics}, 20(2), 712-736.
}
\seealso{
\code{\link{ISE_mixnorm}}, \code{\link{h_isemixnorm}}, \code{\link{MISE_mixnorm}}.
}

