% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenerateUnivariate.R
\name{GenerateUnivariate}
\alias{GenerateUnivariate}
\title{Generate dataset with a single individual identity trait}
\usage{
GenerateUnivariate(nindivs, nobs, betweenM, individuality)
}
\arguments{
\item{nindivs}{Indicates how many individuals should be in dataset}

\item{nobs}{Indicates how many observations per individual should be in dataset}

\item{betweenM}{Indicates the mean value of the trait.}

\item{individuality}{Indicates the ratio of between to within individual
variation.}
}
\value{
Data frame with two columns. Identity codes are in the first column
  and the trait values are in the second column.
}
\description{
This functions generates a dataset with desired parameters (number of
individuals and number of observations per individual, mean of the parameter,
individuality).
}
\examples{
GenerateUnivariate(nindivs=10, nobs=10, betweenM=1000, individuality=2)

}
\seealso{
Other Operations with datasets: \code{\link{GenerateMultivariate}}
}
\concept{Operations with datasets}
