% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permb.R
\name{permb}
\alias{permb}
\title{Permutation Based Tests for Incomplete Paired Data}

\description{
The function Performs testing the hypothesis of equality of means for the incomplete pairs setting data. The function combines the observed mean difference for the complete pairs with the difference between the two means of the independent samples. The function implements two different nonparametric tests based on permutation tests that were proposed by Einsporn and Habtzghi (2013), and Maritz (1995). The two methods are denoted by EH and Maritz, respectively.
}

\usage{
permb(xp, yp, xu, yu, r, mu = NULL, method = "EH",
      alternative = "two.sided", verbose = TRUE)
}

\arguments{
\item{xp, yp}{(non-empty) numeric vectors of data values of the the complete pairs}
\item{xu}{a numeric vector of data on x only}
\item{yu}{a numeric vector of data on y only}
\item{r}{a number indicating the correlation between the complete pairs}
\item{mu}{a number indicating the true value of the mean (or difference in means if you are performing a two sample test)}
\item{method}{a character string specifying the different type of methods, must be one of "EH" (default) or "Maritz"}
\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater" or "less"}
\item{verbose}{if TRUE, show the test used, null and alternative hypotheses in addition to the p-value}
}

\value{A S4 object containing the following components:
\item{Title}{a character string describing the test used}
\item{Nhypothesis}{a character string describing the null hypothesis}
\item{Ahypothesis}{a character string describing the alternative hypothesis}
\item{Pval}{the p-value for the test}
}

\references{
1 Einsporn, R. L., & Habtzghi, D. (2013). Combining paired and two-sample data using a permutation test. Journal of Data Science, 11(4), 767-779.

2 Maritz, J. S. (1995). A permutation paired test allowing for missing values. Australian Journal of Statistics, 37(2), 153-159.

3 Woolson, R., Leeper, J., Cole, J. and Clarke, W. (1976). A Monte Carlo investigation of a statistic for a bivariate missing data problem. Communications in Statistics - Theory and Methods A5, 681-688.
}

\examples{
n=20
n1=15
n2=10
r=0.8
xp=rnorm(n)
yp=r*xp+(1-r)*(rnorm(n))
xu=rnorm(n1)
yu=rnorm(n2)
mu=0
permb(xp,yp,xu,yu,r,mu,method="Maritz",alternative="two.sided")
}
