% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{get_chain_linked}
\alias{get_chain_linked}
\title{Get chain-linked indices}
\usage{
get_chain_linked(x, ref_year, x_a = NULL)
}
\arguments{
\item{x}{(ts) A pyp series.}

\item{ref_year}{(num) Reference year for the chain-linked series.}

\item{x_a}{(ts) Annual pyp series. If not given, it's computed by taking the
average of each year.}
}
\value{
The chain-linked series.
}
\description{
Computes chain-linked index series from a pyp series.
}
\details{
The chain-linked series x_chain is computed with the annual overlap method.
Suppose the x series runs from (y0, p0 = 0) to (y1, p1), where pi is a subyear
period. Then the chain-linked series at (y2, p2) is given by the cumulative
product of the annual series from y0 to y2-1 times x at (y2, p2).
}
\examples{
gdp_pyp <- get_pyp(gdp_volume)
get_chain_linked(gdp_pyp, 2015)

}
