% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_india_literacy_rate.R
\name{get_india_literacy_rate}
\alias{get_india_literacy_rate}
\title{Get India's Adult Literacy Rate from World Bank}
\source{
World Bank Open Data API: \url{https://data.worldbank.org/indicator/SE.ADT.LITR.ZS}
}
\usage{
get_india_literacy_rate()
}
\value{
A tibble with the following columns:
\itemize{
  \item \code{indicator}: Indicator name (e.g., "Literacy rate, adult total (% of people ages 15 and above)")
  \item \code{country}: Country name ("India")
  \item \code{year}: Year of the data (integer)
  \item \code{value}: Adult literacy rate (percentage)
}
}
\description{
Retrieves India's adult literacy rate, defined as the percentage of people
ages 15 and above who can read and write, for the years 2010 to 2022
using the World Bank Open Data API. The indicator used is \code{SE.ADT.LITR.ZS}.
}
\details{
This function sends a GET request to the World Bank API.
If the API request fails or returns an error status code,
the function returns \code{NULL} with an informative message.
}
\note{
Requires internet connection.
}
\examples{
if (interactive()) {
  get_india_literacy_rate()
}

}
\seealso{
\code{\link[httr]{GET}}, \code{\link[jsonlite]{fromJSON}}, \code{\link[dplyr]{as_tibble}}
}
