% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.3way.R
\name{cor.mat.3way}
\alias{cor.mat.3way}
\title{See the correlation matrix for a 3-way interaction}
\usage{
cor.mat.3way(power.results, row.num = 1, return.plot = FALSE)
}
\arguments{
\item{power.results}{Data frame of results from power_interaction_3way_r2().}

\item{row.num}{Which row to show? Can only be a single number. Default is 1.}

\item{return.plot}{Return a matrix (FALSE, default), or a plot (TRUE)?}
}
\value{
A matrix or a ggplot2 object
}
\description{
Prints or plots the correlation matrix for a 3-way interaction
}
\examples{
power_analysis = power_interaction_3way_r2(detailed_results = TRUE,N = c(1000),
r.x1.y = .2,r.x2.y = .3,r.x3.y = .1,r.x1x2.y = .01,r.x1x3.y = .05,r.x2x3.y = .1,
b.x1x2x3 = 0.1,r.x1.x2 = .1,r.x1.x3 = .1,r.x2.x3 = .1,
rel.x1 = 1,rel.x2 = 1,rel.x3 = 1,rel.y = 1 )
cor.mat.3way(power_analysis)
}
