% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agespectrum.R
\name{agespectrum}
\alias{agespectrum}
\alias{agespectrum.default}
\alias{agespectrum.other}
\alias{agespectrum.ArAr}
\title{Plot a (40Ar/39Ar) release spectrum}
\usage{
agespectrum(x, ...)

\method{agespectrum}{default}(
  x,
  oerr = 3,
  plateau = TRUE,
  random.effects = FALSE,
  levels = NULL,
  clabel = "",
  plateau.col = c("#00FF0080", "#FF000080"),
  non.plateau.col = "#00FFFF80",
  sigdig = 2,
  line.col = "red",
  lwd = 2,
  xlab = "cumulative fraction",
  ylab = "X",
  hide = NULL,
  omit = NULL,
  ...
)

\method{agespectrum}{other}(
  x,
  oerr = 3,
  plateau = TRUE,
  random.effects = FALSE,
  levels = NULL,
  clabel = "",
  plateau.col = c("#00FF0080", "#FF000080"),
  non.plateau.col = "#00FFFF80",
  sigdig = 2,
  line.col = "red",
  lwd = 2,
  xlab = "cumulative fraction",
  ylab = "X",
  hide = NULL,
  omit = NULL,
  ...
)

\method{agespectrum}{ArAr}(
  x,
  oerr = 3,
  plateau = TRUE,
  random.effects = FALSE,
  levels = NULL,
  clabel = "",
  plateau.col = c("#00FF0080", "#FF000080"),
  non.plateau.col = "#00FFFF80",
  sigdig = 2,
  exterr = FALSE,
  line.col = "red",
  lwd = 2,
  i2i = FALSE,
  hide = NULL,
  omit = NULL,
  ...
)
}
\arguments{
\item{x}{a three-column matrix whose first column gives the amount of
\eqn{^{39}}Ar in each aliquot, and whose second and third columns
give the age and its uncertainty.

OR

an object of class \code{ArAr}}

\item{...}{optional parameters to the generic \code{plot} function}

\item{oerr}{indicates whether the analytical uncertainties of the
    output are reported in the plot title as:

\code{1}: 1\eqn{\sigma} absolute uncertainties.

\code{2}: 2\eqn{\sigma} absolute uncertainties.

\code{3}: absolute (1-\eqn{\alpha})\% confidence intervals, where
\eqn{\alpha} equales the value that is stored in
\code{settings('alpha')}.

\code{4}: 1\eqn{\sigma} relative uncertainties (\eqn{\%}).

\code{5}: 2\eqn{\sigma} relative uncertainties (\eqn{\%}).

\code{6}: relative (1-\eqn{\alpha})\% confidence intervals, where
\eqn{\alpha} equales the value that is stored in
\code{settings('alpha')}.}

\item{plateau}{logical flag indicating whether a plateau age should
be calculated. If \code{plateau=TRUE}, the function computes
the weighted mean of the largest succession of steps that pass
the Chi-square test for age homogeneity.  If \code{TRUE}, it
returns a list with plateau parameters.}

\item{random.effects}{if \code{TRUE}, computes the weighted mean
    using a random effects model with two parameters: the mean and
    the dispersion. This is akin to a `model-3' isochron
    regression.

    if \code{FALSE}, attributes any excess dispersion to an
    underestimation of the analytical uncertainties. This akin to a
    `model-1' isochron regression.}

\item{levels}{a vector with additional values to be displayed as
different background colours of the plot symbols.}

\item{clabel}{label of the colour legend}

\item{plateau.col}{Fill colours of the rectangles used to mark the steps belonging to
the age plateau. This can either be a single colour or multiple
colours to form a colour ramp (to be used if \code{levels!=NULL}):

a single colour: \code{rgb(0,1,0,0.5)}, \code{'#FF000080'},
\code{'white'}, etc.;

multiple colours: \code{c(rbg(1,0,0,0.5)},
\code{rgb(0,1,0,0.5))}, \code{c('#FF000080','#00FF0080')},
\code{c('blue','red')}, \code{c('blue','yellow','red')}, etc.;

a colour palette: \code{rainbow(n=100)},
\code{topo.colors(n=100,alpha=0.5)}, etc.; or

a reversed palette: \code{rev(topo.colors(n=100,alpha=0.5))},
etc.

For empty boxes, set \code{plateau.col=NA}}

\item{non.plateau.col}{if \code{plateau=TRUE}, the steps that do
NOT belong to the plateau are given a different colour.}

\item{sigdig}{the number of significant digits of the numerical
values reported in the title of the graphical output.}

\item{line.col}{colour of the average age line}

\item{lwd}{width of the average age line}

\item{xlab}{x-axis label}

\item{ylab}{y-axis label}

\item{hide}{vector with indices of aliquots that should be removed
from the plot.}

\item{omit}{vector with indices of aliquots that should be plotted
but omitted from age plateau calculation}

\item{exterr}{propagate the external (decay constant and
calibration factor) uncertainties?}

\item{i2i}{`isochron to intercept': calculates the initial (aka
`inherited', `excess', or `common') \eqn{^{40}}Ar/\eqn{^{36}}Ar
ratio from an isochron fit. Setting \code{i2i} to \code{FALSE}
uses the default values stored in \code{settings('iratio',...)}}
}
\value{
If \code{plateau=TRUE}, returns a list containing the output of the
    \code{weightedmean} function, plus the following items:

\describe{

\item{fract}{the fraction of \eqn{^{39}}Ar contained in the
plateau}

\item{i}{indices of the steps that are retained for the plateau age
calculation}

}
}
\description{
Produces a plot of boxes whose widths correspond to the cumulative
amount of \eqn{^{39}}Ar (or any other variable), and whose heights
express the analytical uncertainties.  Only propagates the
analytical uncertainty associated with decay constants and
J-factors \emph{after} computing the plateau composition.
}
\details{
\code{IsoplotR} defines the `plateau age' as the weighted mean age
(using a random effects model with two sources of dispersion) of
the longest sequence (in terms of cumulative \eqn{^{39}}Ar content)
of consecutive heating steps that pass the modified Chauvenet
criterion (see \code{\link{weightedmean}}).  Note that this
definition is different (and simpler) than the one used by
\code{Isoplot} (Ludwig, 2003). However, it is important to mention
that all definitions of an age plateau are heuristic by nature and
should not be used for quantitative inference. It is possible (and
likely) that the plateau steps exhibit significant
overdispersion. This overdispersion can be manually reduced by
removing individual heating steps with the optional \code{omit}
argument.
}
\examples{
attach(examples)
par(mfrow=c(2,1))
agespectrum(ArAr)
# removing the first 6 steps yields the longest plateau
# that passes the chi-square test for homogeneity
agespectrum(ArAr,omit=1:6)
}
\seealso{
\code{\link{weightedmean}}
}
