% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ps2DGLM.R
\name{ps2DGLM}
\alias{ps2DGLM}
\title{Two-dimensional smoothing of scattered normal or non-normal (GLM)
responses using tensor product P-splines.}
\usage{
ps2DGLM(
  Data,
  Pars = rbind(c(min(Data[, 1]), max(Data[, 1]), 10, 3, 1, 2), c(min(Data[, 2]),
    max(Data[, 2]), 10, 3, 1, 2)),
  ridge_adj = 0,
  XYpred = Data[, 1:2],
  z_predicted = NULL,
  se_pred = 2,
  family = "gaussian",
  link = "default",
  m_binomial = rep(1, nrow(Data)),
  wts = rep(1, nrow(Data)),
  r_gamma = rep(1, nrow(Data))
)
}
\arguments{
\item{Data}{a matrix of 3 columns \code{x, y, z} of equal length;
the response is \code{z}.}

\item{Pars}{a matrix of 2 rows, where the first and second row
sets the P-spline paramters for \code{x} and \code{y}, respectively.
Each row consists of: \code{min max nseg bdeg lambda pord}.
The \code{min} and \code{max} set the ranges, \code{nseg} (default 10)
is the number of evenly spaced segments between \code{min} and \code{max},
\code{bdeg} is the degree of the basis (default 3 for cubic),
\code{lambda} is the (positive) tuning parameter for the penalty (default 1),
\code{pord} is the number for the order of the difference penalty (default 2).}

\item{ridge_adj}{a ridge penalty tuning parameter, usually set to small value, e.g. \code{1e-8} to stabilize estimation (default 0).}

\item{XYpred}{a matrix with two columns \code{(x, y)} that give the coordinates
of (future) prediction; the default is the data locations.}

\item{z_predicted}{a vector of responses associated with \code{XYpred}, useful for external validation with \code{family = "gaussian"}.}

\item{se_pred}{a scalar, default \code{se_pred = 2} to produce se surfaces,
set \code{se_pred} > 0. Used for CIs for \code{XYpred} locations.}

\item{family}{\code{"gaussian", "binomial", "poisson", "Gamma"} (quotes needed). Default is "gaussian".}

\item{link}{the link function, one of \code{"identity"}, \code{"log"}, \code{"sqrt"},
\code{"logit"}, \code{"probit"}, \code{"cloglog"}, \code{"loglog"}, \code{"reciprocal"};
quotes are needed (default \code{"identity"}).}

\item{m_binomial}{vector of binomial trials, default is vector of ones with \code{family = "binomial"}, NULL otherwise.}

\item{wts}{non-negative weights, which can be zero (default ones).}

\item{r_gamma}{gamma scale parameter, default is vector ones with \code{family = "Gamma"}, NULL otherwise.}
}
\value{
\item{pcoef}{a vector of length \code{(Pars[1,3]+Pars[1,4])*(Pars[2,3]+Pars[2,4])}
of (unfolded) estimated P-spline coefficients.}
\item{mu}{a vector of \code{length(z)} of smooth estimated means (at the \code{x,y} locations).}
\item{dev}{the deviance of fit.}
\item{eff_df}{the approximate effective dimension of fit.}
\item{aic}{AIC.}
\item{df_resid}{approximate df residual.}
\item{cv}{leave-one-out standard error prediction, when \code{family = 'gaussian'}.}
\item{cv_predicted}{standard error prediction for \code{y_predict}, when \code{family = 'gaussian'}.}
\item{avediff_pred}{mean absolute difference prediction, when \code{family = 'gaussian'}.}
\item{Pars}{the design and tuning parameters (see arguments above).}
\item{dispersion_parm}{estimate of dispersion, \code{dev/df_resid}.}
\item{summary_predicted}{inverse link prediction vectors, and \code{se_pred} bands.}
\item{eta_predicted}{estimated linear predictor of \code{length(z)}.}
\item{press_mu}{leave-one-out prediction of mean, when \code{family = 'gaussian'}.}
\item{bin_percent_correct}{percent correct classification based on 0.5 cut-off (when \code{family = "binomial"}).}
\item{Data}{a matrix of 3 columns \code{x, y, z} of equal length;
the response is \code{z}.}
\item{Q}{the tensor product B-spline basis.}
\item{qr}{the Q-R of the model.}
}
\description{
\code{ps2DGLM} is used to smooth scattered
normal or non-normal responses, with aniosotripic
penalization of tensor product P-splines.
}
\details{
Support functions needed: \code{pspline_fitter}, \code{bbase}, and \code{pspline_2dchecker}.
}
\examples{
library(fields)
library(JOPS)
# Extract data
library(rpart)
Kyphosis <- kyphosis$Kyphosis
Age <- kyphosis$Age
Start <- kyphosis$Start
y <- 1 * (Kyphosis == "present") # make y 0/1
fit <- ps2DGLM(
  Data = cbind(Start, Age, y),
  Pars = rbind(c(1, 18, 10, 3, .1, 2), c(1, 206, 10, 3, .1, 2)),
  family = "binomial", link = "logit")
plot(fit, xlab = "Start", ylab = "Age")
#title(main = "Probability of Kyphosis")
}
\references{
Eilers, P.H.C. and Marx, B.D. (2021). \emph{Practical Smoothing, The Joys of
P-splines.} Cambridge University Press.

Eilers, P.H.C., Marx, B.D., and Durban, M. (2015).
Twenty years of P-splines, \emph{SORT}, 39(2): 149-186.
}
\seealso{
ps2DNormal
}
\author{
Paul Eilers and Brian Marx
}
