% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaboost.R
\name{predict.adaboost}
\alias{predict.adaboost}
\title{Create predictions from AdaBoost fit}
\usage{
\method{predict}{adaboost}(object, X, type = c("response", "prob"),
  n_tree = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{adaboost} returned by the \code{adaboost} function.}

\item{X}{A design matrix of predictors.}

\item{type}{The type of prediction to return.  If \code{type="response"}, a
class label of -1 or 1 is returned.  If \code{type="prob"}, the
probability \eqn{p(y = 1 | x)} is returned.}

\item{n_tree}{The number of trees to use in the prediction (by default, all
them).}

\item{...}{\dots}
}
\value{
Returns a vector of class predictions if \code{type="response"}, or a
         vector of class probabilities \eqn{p(y=1|x)} if \code{type="prob"}.
}
\description{
Makes a prediction on new data for a given fitted \code{adaboost} model.
}
\note{
Probabilities are estimated according to the formula:
      \deqn{p(y=1| x) = 1/(1 + exp(-2*f(x)))}
      where \eqn{f(x)} is the score function produced by AdaBoost.  See
      Friedman (2000).
}
\examples{
\dontrun{
# Generate data from the circle model
set.seed(111)
dat = circle_data(n = 500)
train_index = sample(1:500, 400)

ada = adaboost(dat$X[train_index,], dat$y[train_index], tree_depth = 2,
               n_rounds = 100, verbose = TRUE)
# get class prediction
yhat = predict(ada, dat$X[-train_index, ])
# get probability estimate
phat = predict(ada, dat$X[-train_index, ], type="prob")
}

}
\references{
Friedman, J., Hastie, T. and Tibshirani, R. (2000). Additive logistic
regression: a statistical view of boosting (with discussion), Annals of
Statistics 28: 337-307.
}
