% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{life_exp_japan_tbl_df}
\alias{life_exp_japan_tbl_df}
\title{Japan Life Expectancy and Socioeconomic Indicators (2020)}
\format{
A tibble with 47 observations and 23 variables:
\describe{
  \item{Prefecture}{Name of the Japanese prefecture (character)}
  \item{Life_expectancy}{Average life expectancy (numeric)}
  \item{Physician}{Number of physicians per 100,000 people (numeric)}
  \item{Junior_col}{Number of junior colleges (numeric)}
  \item{University}{Number of universities (numeric)}
  \item{Public_Hosp}{Number of public hospitals (numeric)}
  \item{Pshic_hosp}{Number of psychiatric hospitals (numeric)}
  \item{Beds_psic}{Number of psychiatric hospital beds (numeric)}
  \item{Nurses}{Number of nurses per 100,000 people (numeric)}
  \item{Avg_hours}{Average weekly working hours (numeric)}
  \item{Salary}{Average annual salary (numeric)}
  \item{Elementary_school}{Number of elementary schools (numeric)}
  \item{Sport_fac}{Number of sports facilities (numeric)}
  \item{Park}{Number of parks (numeric)}
  \item{Forest}{Percentage of forest area (numeric)}
  \item{Income_per capita}{Per capita income (numeric)}
  \item{Density_pop}{Population density (people per km²) (numeric)}
  \item{Hospitals}{Total number of hospitals (numeric)}
  \item{Beds}{Total number of hospital beds (numeric)}
  \item{Ambulances}{Number of ambulances (numeric)}
  \item{Health_exp}{Health expenditure per capita (numeric)}
  \item{Educ_exp}{Education expenditure per capita (numeric)}
  \item{Welfare_exp}{Welfare expenditure per capita (numeric)}
}
}
\source{
Data obtained from Kaggle: \url{https://www.kaggle.com/datasets/gianinamariapetrascu/japan-life-expectancy}
}
\usage{
data(life_exp_japan_tbl_df)
}
\description{
This dataset, life_exp_japan_tbl_df, is a tibble containing life expectancy and related
economic and social indicators for Japan's 47 prefectures as of 2020. It includes variables
on healthcare infrastructure, education levels, income, public spending, and environmental indicators.
The dataset preserves the original structure from its source on Kaggle.
}
\details{
The dataset name has been kept as 'life_exp_japan_tbl_df' to maintain consistency with the naming conventions
in the JapanAPIs package. The suffix 'tbl_df' indicates that this is a tibble data frame. The original content
has not been modified in any way.
}
