% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.R
\name{confint.KFS}
\alias{confint.KFS}
\title{Confidence Intervals of Smoothed States}
\usage{
\method{confint}{KFS}(object, parm = "all", level = 0.95, ...)
}
\arguments{
\item{object}{An object of class \code{KFS}.}

\item{parm}{Which states to extract? Either a numeric vector containing
the indices of the corresponding states, or a character vector defining the
types of the corresponding states. Possible choices are
 \code{"all"},  \code{"level"}, \code{"slope"},
 \code{"trend"},  \code{"regression"}, \code{"arima"}, \code{"custom"},
 \code{"cycle"} or \code{"seasonal"}, where \code{"trend"} extracts all states
 relating to trend. These can be combined. Default is \code{"all"}.}

\item{level}{The confidence level required. Defaults to 0.95.}

\item{\dots}{Ignored.}
}
\value{
A list of confidence intervals for each state
}
\description{
Extract confidence intervals of the smoothed estimates of states from the 
output of \code{KFS}.
}
\examples{

model <- SSModel(log(drivers) ~ SSMtrend(1, Q = list(1)) +
 SSMseasonal(period = 12, sea.type = "trigonometric") +
 log(PetrolPrice) + law, data = Seatbelts, H = 1)
out <- KFS(model)

confint(out, parm = "regression")

}
